/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IIconStyle;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.items.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class HarvestInfoTools {
    private static final ResourceLocation ICONS = new ResourceLocation("theoneprobe", "textures/gui/icons.png");

    private static String getTools(BlockState state) {
        Set tags = ForgeRegistries.BLOCKS.getResourceKey((IForgeRegistryEntry)state.m_60734_()).map(key -> Registry.f_122824_.m_206081_(key).m_203616_().collect(Collectors.toSet())).orElse(Collections.emptySet());
        Map<ResourceLocation, String> tooltypes = Config.getTooltypeTags();
        Object tools = "";
        for (TagKey tag : tags) {
            String s = tooltypes.get(tag.f_203868_());
            if (s == null) continue;
            if (!((String)tools).isEmpty()) {
                tools = (String)tools + " ";
            }
            tools = (String)tools + s;
        }
        return tools;
    }

    private static String getLevels(BlockState state) {
        Set tags = ForgeRegistries.BLOCKS.getResourceKey((IForgeRegistryEntry)state.m_60734_()).map(key -> Registry.f_122824_.m_206081_(key).m_203616_().collect(Collectors.toSet())).orElse(Collections.emptySet());
        Map<ResourceLocation, String> harvestability = Config.getHarvestabilityTags();
        Object levels = "";
        for (TagKey tag : tags) {
            String s = harvestability.get(tag.f_203868_());
            if (s == null) continue;
            if (!((String)levels).isEmpty()) {
                levels = (String)levels + " ";
            }
            levels = (String)levels + s;
        }
        return levels;
    }

    static void showHarvestLevel(IProbeInfo probeInfo, BlockState state) {
        String tools = HarvestInfoTools.getTools(state);
        String levels = HarvestInfoTools.getLevels(state);
        if (!tools.isEmpty() && !levels.isEmpty()) {
            probeInfo.text(CompoundText.createLabelInfo("Tools: ", tools + " (level " + levels + ")"));
        } else if (!tools.isEmpty()) {
            probeInfo.text(CompoundText.createLabelInfo("Tools: ", tools));
        } else if (!levels.isEmpty()) {
            probeInfo.text(CompoundText.createLabelInfo("Level: ", levels));
        }
    }

    static void showCanBeHarvested(IProbeInfo probeInfo, Level world, BlockPos pos, BlockState state, Player player) {
        if (ModItems.isProbeInHand(player.m_21205_())) {
            return;
        }
        ItemStack stack = player.m_21205_();
        boolean harvestable = stack.m_41720_().isCorrectToolForDrops(stack, state);
        if (harvestable) {
            probeInfo.text(CompoundText.create().style(TextStyleClass.OK).text("Harvestable"));
        } else {
            probeInfo.text(CompoundText.create().style(TextStyleClass.WARNING).text("Not harvestable"));
        }
    }

    static void showHarvestInfo(IProbeInfo probeInfo, Level world, BlockPos pos, Block block, BlockState blockState, Player player) {
        ItemStack stack = player.m_21205_();
        boolean harvestable = stack.m_41720_().isCorrectToolForDrops(stack, blockState);
        String tools = HarvestInfoTools.getTools(blockState);
        String levels = HarvestInfoTools.getLevels(blockState);
        boolean v = (Boolean)Config.harvestStyleVanilla.get();
        int offs = v ? 16 : 0;
        int dim = v ? 13 : 16;
        ILayoutStyle alignment = probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER);
        IIconStyle iconStyle = probeInfo.defaultIconStyle().width(v ? 18 : 20).height(v ? 14 : 16).textureWidth(32).textureHeight(32);
        IProbeInfo horizontal = probeInfo.horizontal(alignment);
        if (harvestable) {
            horizontal.icon(ICONS, 0, offs, dim, dim, iconStyle).text(CompoundText.create().style(TextStyleClass.OK).text(tools.isEmpty() ? "No tool" : tools));
        } else if (levels.isEmpty()) {
            horizontal.icon(ICONS, 16, offs, dim, dim, iconStyle).text(CompoundText.create().style(TextStyleClass.WARNING).text(tools.isEmpty() ? "No tool" : tools));
        } else {
            horizontal.icon(ICONS, 16, offs, dim, dim, iconStyle).text(CompoundText.create().style(TextStyleClass.WARNING).text((tools.isEmpty() ? "No tool" : tools) + " (level " + levels + ")"));
        }
    }
}

